<?php
include '../includes/db.php';

// ফাইল আপলোডের জন্য ডিরেক্টরি তৈরি করা হয়েছে কিনা তা পরীক্ষা করুন
$upload_dir = '../uploads/stream_thumbnails/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// নতুন স্ট্রিম যোগ করার লজিক
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['stream_url'])) {
    $title = $conn->real_escape_string($_POST['stream_title']);
    $stream_url = $conn->real_escape_string($_POST['stream_url']);
    $thumbnail_path = null;

    // --- থাম্বনেইল আপলোড লজিক শুরু ---
    if (isset($_FILES['thumbnail_file']) && $_FILES['thumbnail_file']['error'] == 0) {
        $thumb_file_name = time() . '_' . basename($_FILES["thumbnail_file"]["name"]);
        $thumb_target_file = $upload_dir . $thumb_file_name;
        $thumb_file_type = strtolower(pathinfo($thumb_target_file, PATHINFO_EXTENSION));

        // ছবিটি বৈধ কিনা তা পরীক্ষা করুন
        $check = getimagesize($_FILES["thumbnail_file"]["tmp_name"]);
        if ($check !== false) {
            if (move_uploaded_file($_FILES["thumbnail_file"]["tmp_name"], $thumb_target_file)) {
                $thumbnail_path = "uploads/stream_thumbnails/" . $thumb_file_name;
            } else {
                $message = "<div class='alert alert-danger'>দুঃখিত, থাম্বনেইল আপলোডের সময় একটি ত্রুটি হয়েছে।</div>";
            }
        } else {
            $message = "<div class='alert alert-warning'>ফাইলটি একটি ছবি নয়।</div>";
        }
    }
    // --- থাম্বনেইল আপলোড লজিক শেষ ---

    if (filter_var($stream_url, FILTER_VALIDATE_URL) && !isset($message)) {
        $sql = "INSERT INTO live_streams (title, stream_url, thumbnail_path) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $title, $stream_url, $thumbnail_path);
        
        if ($stmt->execute()) {
            $message = "<div class='alert alert-success'>নতুন স্ট্রিম সফলভাবে যোগ হয়েছে।</div>";
        } else {
            $message = "<div class='alert alert-danger'>ত্রুটি: " . $conn->error . "</div>";
        }
    } elseif (!isset($message)) {
         $message = "<div class='alert alert-warning'>অনুগ্রহ করে একটি বৈধ URL দিন।</div>";
    }
}
?>

<?php include '../includes/header.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<h1 class="mt-4">লাইভ স্ট্রিম ম্যানেজমেন্ট</h1>

<?php
if (isset($message)) {
    echo $message;
}
?>

<!-- স্ট্রিম যোগ করার ফর্ম -->
<div class="card my-4">
    <div class="card-header">নতুন লাইভ স্ট্রিম যোগ করুন</div>
    <div class="card-body">
        <form action="manage_streams.php" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="stream_title">স্ট্রিমের টাইটেল</label>
                <input type="text" name="stream_title" id="stream_title" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="stream_url">স্ট্রিম URL</label>
                <input type="url" name="stream_url" id="stream_url" class="form-control" placeholder="http:// বা https:// দিয়ে শুরু করুন" required>
            </div>
            <div class="form-group">
                <label for="thumbnail_file">স্ট্রিমের থাম্বনেইল (ছবি)</label>
                <input type="file" name="thumbnail_file" id="thumbnail_file" class="form-control-file" accept="image/*">
            </div>
            <button type="submit" class="btn btn-primary">যোগ করুন</button>
        </form>
    </div>
</div>

<!-- বিদ্যমান স্ট্রিম দেখানোর টেবিল -->
<div class="card">
     <div class="card-header">বিদ্যমান লাইভ স্ট্রিম</div>
    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th style="width: 10%;">আইডি</th>
                    <th style="width: 15%;">থাম্বনেইল</th>
                    <th>টাইটেল</th>
                    <th>URL</th>
                    <th style="width: 20%;">অ্যাকশন</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT id, title, stream_url, thumbnail_path FROM live_streams ORDER BY id DESC";
                $result = $conn->query($sql);
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $row["id"] . "</td>";
                        // থাম্বনেইল প্রদর্শন
                        echo "<td>";
                        if (!empty($row['thumbnail_path']) && file_exists('../' . $row['thumbnail_path'])) {
                            echo "<img src='../" . htmlspecialchars($row['thumbnail_path']) . "' alt='" . htmlspecialchars($row['title']) . "' class='img-fluid img-thumbnail' style='max-height: 70px;'>";
                        } else {
                            echo "N/A";
                        }
                        echo "</td>";
                        echo "<td>" . htmlspecialchars($row["title"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["stream_url"]) . "</td>";
                        echo "<td>
                                <a href='edit_stream.php?id=" . $row['id'] . "' class='btn btn-sm btn-info'>এডিট</a>
                                <a href='delete_stream.php?id=" . $row['id'] . "' class='btn btn-sm btn-danger' onclick='return confirm(\"আপনি কি সত্যিই এই স্ট্রিমটি ডিলিট করতে চান?\")'>ডিলিট</a>
                              </td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='5' class='text-center'>কোনো স্ট্রিম পাওয়া যায়নি</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
<?php $conn->close(); ?>